import yaml
from scenarios import load_scenario, display_options, process_choice

def load_data(file_path):
    with open(file_path, 'r') as file:
        return yaml.safe_load(file)

def play_game(start_scenario):
    current_scenario = start_scenario
    while True:
        scenario_data = load_scenario(current_scenario)
        if not scenario_data:
            print(f"Scenario not found. Game over. {current_scenario}")
            break

        print(f"\n--- {scenario_data['name']} ---")
        print(scenario_data['description'])

        options = scenario_data['options']
        if not options:
            print("Congratulations! You have completed the game.")
            break

        display_options(options)
        choice = input("Enter your choice: ")
        next_scenario = process_choice(options, choice)

        if next_scenario:
            current_scenario = next_scenario
        else:
            print("Invalid choice. Please try again.")

def main():
    data = load_data('data/main.yaml')
    print(data['welcome_message'])
    start_scenario = data['start_scenario']
    play_game(start_scenario)
    print(data['end_message'])

if __name__ == '__main__':
    main()
