import yaml

def load_scenario(scenario_name):
    try:
        with open(f'data/scenarios/{scenario_name}.yaml', 'r') as file:
            return yaml.safe_load(file)
    except FileNotFoundError:
        return None

def display_options(options):
    print("\nOptions:")
    for option in options:
        print(f"{option['choice']}. {option['text']}")

def process_choice(options, choice):
    for option in options:
        if option['choice'] == choice:
            return option.get('next_scenario')
    return None
